#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;
const int kMod = 1000 * 1000 * 1000 + 7;

const int kN = 2 * 1000 + 1;
const int kD = 2 * 1000 + 1;

ll dp[kN][kD];

ll Pow(int a, int n) {
  ll res = 1;
  ll carry = a;
  while (n) {
    if (n & 1)
      res = (res * carry) % kMod;
    carry = (carry * carry) % kMod;
    n >>= 1;
  }
  return res;
}

int x;

ll DP(int n, int k) {
  if (k < 0 || n < 0) {
    return 0;
  }
  if (n == 0 && k == 0) {
    return 1;
  }
  if (n == 0) {
    return 0;
  }
  if (k == 0 && n != 0) {
    return 0;
  }
  if (k > n) {
    return 0;
  }
  if (dp[n][k] == -1) {
    dp[n][k] = DP(n - 1, k);
    dp[n][k] = (dp[n][k] + DP(n - 1, k - 1)) % kMod;
    dp[n][k] = (dp[n][k] + kMod - DP(n - x, k - 1)) % kMod;
    //}
  }
  return dp[n][k];
}

ll C(ll d, int k) {
  ll res = 1;
  for (int i = 0; i < k; ++i)
    res = (res * (d - i)) % kMod;
  ll fact = 1;
  for (int i = 2; i <= k; ++i) {
    fact = (fact * i) % kMod;
  }
  res = (res * Pow(fact, kMod - 2)) % kMod;
  return res;
}

int main() {
  int n;
  ll d;                                      
  while (cin >> n >> d >> x && n && d && x) {
    memset(dp, 255, sizeof(dp));
    /*
    dp[0][0] = 1;
    int mn = min((ll)n, d);
    for (int i = 1; i <= n; ++i) {
      ll curr = 0;
      for (int k = 1; k <= mn; ++k) {
         curr = (curr + dp[n - k][k - 1]) % kMod;
         dp[n][k] = curr;
       //for (int d = 1; d < x; ++d)
       //  dp[n][k] = (dp[n][k] + DP(n - d, k - 1)) % kMod;
          
      }
    }
    */
    ll res = 0;
    int mn = min((ll)n, d);
    for (int k = 1; k <= mn; ++k) {
      ll add = (DP(n, k) * C(d, k)) % kMod;
      res = (res + add) % kMod;
    }
    cout << res << '\n';
    /*
    for (int i = 0; i <= n; ++i) {
      for (int j = 0; j <= n; ++j) {
        cout << DP(i, j) << ' ';
      }
      cout << '\n';
    */
  }
  return 0;
}